<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesContact extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-contact';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages Contact', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Pages Contact', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
		$position_options = [
			''              => esc_html__('Default', 'bdevs-elementor'),
			'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
			'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
			'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
			'center'        => esc_html__('Center', 'bdevs-elementor') ,
			'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
			'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
			'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
			'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
			'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
		];

		return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_address',
			[
				'label' => esc_html__( 'Address Widget', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Address Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [				
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_address',
						'label'       => esc_html__( 'Address', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Address' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'phone_email',
						'label'       => esc_html__( 'Phone And Email', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Phone, Email' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'section_contact',
			[
				'label' => esc_html__( 'Contact Widget', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Sub Heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'iframe_link',
			[
				'label'       => __( 'Iframe Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Iframe Link', 'bdevs-elementor' ),
				'default'     => __( 'It is Iframe Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_form',
			[
				'label'       => __( 'Contact Form', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Contact Form', 'bdevs-elementor' ),
				'default'     => __( 'It is Contact Form', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);


		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		); 	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_iframe',
			[
				'label'   => esc_html__( 'Show Iframe', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_contact_form',
			[
				'label'   => esc_html__( 'Show Contact Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<div class="contact-section pt-0 pb-60">
			<div class="container-fluid">
				<div class="row pb-60">
					<?php foreach ( $settings['tabs'] as $item ) : ?>
					<div class="col-md-4 mb-30 animate-box" data-animate-effect="fadeInLeft">
						<div class="line p-30">
							<?php if ( '' !== $item['tab_title'] ) : ?>
							<p><i class="ti-location-pin"></i> <b><?php echo wp_kses_post($item['tab_title']); ?></b></p>
							<?php endif; ?>
							<?php if ( '' !== $item['tab_address'] ) : ?>
							<p class="mb-0"><?php echo wp_kses_post($item['tab_address']); ?></p>
							<?php endif; ?>
								<div class="separator"></div>
							<?php if ( '' !== $item['phone_email'] ) : ?>
								<p><?php echo wp_kses_post($item['phone_email']); ?></p>
								<?php endif; ?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<!-- Map Section-->
				<div class="map-section">
					<div class="row">
						<div class="col-md-6 mb-30 animate-box" data-animate-effect="fadeInLeft">
							<?php if (( '' !== $settings['iframe_link'] ) && ( $settings['show_iframe'] )): ?>
							<iframe src="<?php echo wp_kses_post($settings['iframe_link']); ?>" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
							<?php endif; ?>
						</div>
						<div class="col-md-6 animate-box" data-animate-effect="fadeInLeft">
							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
							<h3 class="pwe-about-heading"><?php echo wp_kses_post($settings['heading']); ?></h3>
							<?php endif; ?>
							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
							<p><?php echo wp_kses_post($settings['sub_heading']); ?></p>
							<?php endif; ?>
							<?php if (( '' !== $settings['contact_form'] ) && ( $settings['show_contact_form'] )): ?>
							<?php echo do_shortcode(wp_kses_post($settings['contact_form'])); ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php
	}

}
