<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesTeam extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages Team', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Pages Team', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
		$position_options = [
			''              => esc_html__('Default', 'bdevs-elementor'),
			'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
			'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
			'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
			'center'        => esc_html__('Center', 'bdevs-elementor') ,
			'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
			'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
			'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
			'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
			'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
		];

		return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_team',
			[
				'label' => esc_html__( 'Team Widget', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading_meta',
			[
				'label'       => __( 'Heading Meta', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Heading Meta', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading Meta', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Team Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Tab Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],				
					[
						'name'        => 'tab_author',
						'label'       => esc_html__( 'Author', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Author' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_job',
						'label'       => esc_html__( 'Job', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Job' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'social_title',
						'label'       => esc_html__( 'Social Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Social Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_social',
						'label'       => esc_html__( 'Social Contact', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Social Contact' , 'bdevs-elementor' ),
					],
				],
			]
		);


		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		); 

		$this->add_control(
			'show_heading_meta',
			[
				'label'   => esc_html__( 'Show Heading Meta', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<div class="team-section team pt-90 pb-90 bg-pink">

			<div class="container-fluid">

				<div class="row">

					<div class="col-md-12 mb-30"> 
						<?php if (( '' !== $settings['heading_meta'] ) && ( $settings['show_heading_meta'] )): ?>
						<span class="heading-meta"><?php echo wp_kses_post($settings['heading_meta']); ?></span>
					<?php endif; ?>

					<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
					<h2 class="pwe-heading mb-30 animate-box" data-animate-effect="fadeInLeft"><?php echo wp_kses_post($settings['heading']); ?></h2>
				<?php endif; ?>

			</div>

		</div>

		<div class="row">

			<div class="col-md-12 owl-carousel owl-theme animate-box" data-animate-effect="fadeInLeft">

				<?php foreach ( $settings['tabs'] as $item ) : ?>

					<div class="item">

						<?php if ( '' !== $item['tab_image']['url'] ) : ?>
							<div class="img"> <img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt=""> </div>
						<?php endif; ?>

						<div class="info">

							<?php if ( '' !== $item['tab_author'] ) : ?>
								<h6><?php echo wp_kses_post($item['tab_author']); ?></h6>
							<?php endif; ?>

							<?php if ( '' !== $item['tab_job'] ) : ?>
								<p><?php echo wp_kses_post($item['tab_job']); ?></p>
							<?php endif; ?>

							<div class="social valign">

								<div class="full-width">

									<?php if ( '' !== $item['social_title'] ) : ?>
										<p><i><?php echo wp_kses_post($item['social_title']); ?></i></p> 
									<?php endif; ?>

									<?php if ( '' !== $item['tab_social'] ) : ?>
										<?php echo wp_kses_post($item['tab_social']); ?>
									<?php endif; ?>

								</div>

							</div>

						</div>

					</div>

				<?php endforeach; ?>

			</div>

		</div>

	</div>

</div>

		<?php
	}

}
