<?php
// register post type Portfolio

add_action( 'init', 'register_pwe_Service' );
function register_pwe_Service() {
    
    $labels = array( 
        'name' => __( 'Service', 'pwe' ),
        'singular_name' => __( 'Service', 'pwe' ),
        'add_new' => __( 'Add New Service', 'pwe' ),
        'add_new_item' => __( 'Add New Service', 'pwe' ),
        'edit_item' => __( 'Edit Service', 'pwe' ),
        'new_item' => __( 'New Service', 'pwe' ),
        'view_item' => __( 'View Service', 'pwe' ),
        'search_items' => __( 'Search Service', 'pwe' ),
        'not_found' => __( 'No Service found', 'pwe' ),
        'not_found_in_trash' => __( 'No Service found in Trash', 'pwe' ),
        'parent_item_colon' => __( 'Parent Service:', 'pwe' ),
        'menu_name' => __( 'Service', 'pwe' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Service',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
        'taxonomies' => array( 'Service', 'type' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-hammer', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_style' => 'post'
    );

    register_post_type( 'Service', $args );
}
add_action( 'init', 'create_ServiceType_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_ServiceType_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Type', 'pwe' ),
    'singular_name' => __( 'Type', 'pwe' ),
    'search_items' =>  __( 'Search Type','pwe' ),
    'all_items' => __( 'All Type','pwe' ),
    'parent_item' => __( 'Parent Type','pwe' ),
    'parent_item_colon' => __( 'Parent Type:','pwe' ),
    'edit_item' => __( 'Edit Type','pwe' ), 
    'update_item' => __( 'Update Type','pwe' ),
    'add_new_item' => __( 'Add New Type','pwe' ),
    'new_item_name' => __( 'New Type Name','pwe' ),
    'menu_name' => __( 'Type','pwe' ),
  );     

// Now register the taxonomy

  register_taxonomy('type',array('Service',), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type' ),
  ));


}




add_action( 'init', 'register_pwe_Portfolio' );
function register_pwe_Portfolio() {
    
    $labels = array( 
        'name' => __( 'Portfolio', 'pwe' ),
        'singular_name' => __( 'Portfolio', 'pwe' ),
        'add_new' => __( 'Add New Portfolio', 'pwe' ),
        'add_new_item' => __( 'Add New Portfolio', 'pwe' ),
        'edit_item' => __( 'Edit Portfolio', 'pwe' ),
        'new_item' => __( 'New Portfolio', 'pwe' ),
        'view_item' => __( 'View Portfolio', 'pwe' ),
        'search_items' => __( 'Search Portfolio', 'pwe' ),
        'not_found' => __( 'No Portfolio found', 'pwe' ),
        'not_found_in_trash' => __( 'No Portfolio found in Trash', 'pwe' ),
        'parent_item_colon' => __( 'Parent Portfolio:', 'pwe' ),
        'menu_name' => __( 'Portfolio', 'pwe' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Portfolio',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
        'taxonomies' => array( 'Portfolio', 'type1' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-groups', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_style' => 'post'
    );

    register_post_type( 'Portfolio', $args );
}
add_action( 'init', 'create_PortfolioType_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_PortfolioType_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Type', 'pwe' ),
    'singular_name' => __( 'Type', 'pwe' ),
    'search_items' =>  __( 'Search Type','pwe' ),
    'all_items' => __( 'All Type','pwe' ),
    'parent_item' => __( 'Parent Type','pwe' ),
    'parent_item_colon' => __( 'Parent Type:','pwe' ),
    'edit_item' => __( 'Edit Type','pwe' ), 
    'update_item' => __( 'Update Type','pwe' ),
    'add_new_item' => __( 'Add New Type','pwe' ),
    'new_item_name' => __( 'New Type Name','pwe' ),
    'menu_name' => __( 'Type','pwe' ),
  );     

// Now register the taxonomy

  register_taxonomy('type1',array('Portfolio',), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type1' ),
  ));


}