<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandwedding_page_gallery_id = grandwedding_get_page_gallery_id();
if(!empty($grandwedding_page_gallery_id))
{
	$current_page_id = $grandwedding_page_gallery_id;
}

//important to apply dynamic header & footer style
$grandwedding_homepage_style = grandwedding_get_homepage_style();

$grandwedding_homepage_style = 'fullscreen_white';
grandwedding_set_homepage_style($grandwedding_homepage_style);

get_header();

//Run flow gallery data
wp_enqueue_script("grandwedding-ppflip", get_template_directory_uri()."/js/jquery.ppflip.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("touchwipe", get_template_directory_uri()."/js/jquery.touchwipe.1.1.1.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("grandwedding-script-flow-gallery", admin_url('admin-ajax.php')."?action=grandwedding_script_flow_gallery&gallery_id=".$current_page_id, false, GRANDWEDDING_THEMEVERSION, true);
?>
<a id="imgflow-prevslide" class="load-item"></a>
<a id="imgflow-nextslide" class="load-item"></a>

<div id="imageFlow">
	<div class="text">
		<div class="title"></div>
		<div class="legend"></div>
	</div>
</div>

<div id="controls-wrapper" class="load-item" style="display: block;">
	<div id="controls">
		<div id="slidecaption">
			<div class="tg_caption">
				<div class="caption_wrapper">
					<?php
						$gallery_excerpt = get_the_excerpt();
			
				    	if(!empty($gallery_excerpt))
				    	{
				    ?>
						<div class="tg_desc"><?php echo wp_kses_post($gallery_excerpt); ?></div>
					<?php
						}
					?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
	$tg_flow_enable_reflection = kirki_get_option('tg_flow_enable_reflection');
?>
<input type="hidden" id="tg_flow_enable_reflection" name="tg_flow_enable_reflection" value="<?php echo esc_attr($tg_flow_enable_reflection); ?>"/>

<?php
	$tg_flow_enable_lightbox = kirki_get_option('tg_flow_enable_lightbox');
	
	if(!empty($tg_flow_enable_lightbox))
	{
?>
<div id="fancy_gallery" style="display:none">
<?php
$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);
	
//Get gallery sorting
$all_photo_arr = grandwedding_resort_gallery_img($all_photo_arr);

foreach($all_photo_arr as $key => $photo)
{
	$full_image_url = wp_get_attachment_image_src( $photo, 'original' );
	$image_caption = get_post_field('post_excerpt', $photo);
?>
<a id="fancy_gallery<?php echo esc_attr($key); ?>" href="<?php echo esc_url($full_image_url[0]); ?>" class="fancy-gallery" <?php if(!empty($tg_full_image_caption)) { ?> data-caption="<?php echo esc_html($image_caption); ?>" <?php } ?>></a>
<?php
}
?>
</div>
<?php
	}
?>

<?php get_footer(); ?>