<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandwedding_page_gallery_id = grandwedding_get_page_gallery_id();
if(!empty($grandwedding_page_gallery_id))
{
	$current_page_id = $grandwedding_page_gallery_id;
}

//Get gallery images
$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);

//Get gallery sorting
$all_photo_arr = grandwedding_resort_gallery_img($all_photo_arr);

$grandwedding_homepage_style = grandwedding_get_homepage_style();
grandwedding_set_homepage_style('horizontal');

get_header();

wp_enqueue_script("mousewheel", get_template_directory_uri()."/js/jquery.mousewheel.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("grandwedding-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, GRANDWEDDING_THEMEVERSION, true);

$grandwedding_topbar = grandwedding_get_topbar();

$grandwedding_page_content_class = grandwedding_get_page_content_class();
grandwedding_set_page_content_class('wide nomargin');

//Get gallery header
get_template_part("/templates/template-gallery-header");
?>
<!-- Begin content -->
<div id="page_content_wrapper" class="transparent horizontal">
	<div id="horizontal_gallery">
	<table id="horizontal_gallery_wrapper">
	<tbody><tr>
	<?php
	    foreach($all_photo_arr as $photo_id)
		{
		    $small_image_url = '';
		    $hyperlink_url = get_permalink($photo_id);
		    $thumb_image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
	?>
	<td>
	    <?php 
	    	if(isset($image_url[0]) && !empty($image_url[0]))
	    	{
	    		//Check if enable horizontal gallery lightbox
	    		$tg_lightbox_enable_horizontal_gallery = kirki_get_option('tg_lightbox_enable_horizontal_gallery');
	    ?>
	    	<div class="gallery_image_wrapper">
		    	<?php
			    	if(!empty($tg_lightbox_enable_horizontal_gallery))
			    	{
			    ?>
			    	<a <?php if(!empty($tg_full_image_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
			    <?php
			    	}
			    ?>
		    		<img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" class="horizontal_gallery_img"/>
		    	<?php
				    if(!empty($tg_lightbox_enable_horizontal_gallery))
				    {
				?>
				    </a>
				<?php
				    }		
				?>
				 
				 <?php
				 	if(!empty($image_caption))
				 	{
				 ?>
					 <div class="image_caption_wrapper">
				    	<div class="image_caption">
						    <?php echo esc_html($image_caption); ?>
					    </div>
					 </div>
				<?php
					}
				?>
	    	</div>
	    <?php
	    	}		
	    ?>
	</td>
	
	<?php
	    }
	?>
	</tr></tbody>
	</table>
	
	</div>
</div>

<?php get_footer(); ?>