<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandwedding_page_gallery_id = grandwedding_get_page_gallery_id();
if(!empty($grandwedding_page_gallery_id))
{
	$current_page_id = $grandwedding_page_gallery_id;
}

//important to apply dynamic header & footer style
$grandwedding_homepage_style = grandwedding_get_homepage_style();

$tg_kenburns_menu_transparent = kirki_get_option('tg_kenburns_menu_transparent');
if(empty($tg_kenburns_menu_transparent))
{
	$grandwedding_homepage_style = 'fullscreen_white';
}
else
{
	$grandwedding_homepage_style = 'fullscreen';
}
grandwedding_set_homepage_style($grandwedding_homepage_style);

get_header();

wp_enqueue_script("grandwedding-kenburns", get_template_directory_uri()."/js/kenburns.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("grandwedding-kenburns-gallery", admin_url('admin-ajax.php')."?action=grandwedding_script_kenburns_gallery&gallery_id=".$current_page_id, false, GRANDWEDDING_THEMEVERSION, true);
?>
<div id="kenburns_overlay"></div>
<canvas id="kenburns">
    <p><?php esc_html_e('Your browser doesn\'t support canvas!', 'grandwedding' ); ?></p>
</canvas>

<?php get_footer(); ?>